//+------------------------------------------------------------------+
//|                                                Price Channel.mq4 |
//|                                                                  |
//|                                       http://forex.kbpauk.ru/    |
//+------------------------------------------------------------------+
#property link      "http://forex.kbpauk.ru/"
//----     
#property indicator_chart_window 
//----   
#property indicator_buffers 3
//----  
#property indicator_color1 Lime
#property indicator_color2 Blue
#property indicator_color3 Red
//----   Bollinger Bands
#property indicator_style1 4
#property indicator_style2 2
#property indicator_style3 4
//----    ----------------------------+
extern int ChannelPeriod=14;//  
extern int Shift  = 0;   // c     
//---- +--------------------------------------------------------+
//----  
double UpBuffer[];
double DnBuffer[];
double MdBuffer[];
//+------------------------------------------------------------------+
//| Price Channel initialization function                            |
//+------------------------------------------------------------------+
int init()
  {
//----     
   IndicatorDigits(Digits);
//----    
   SetIndexStyle(0,DRAW_LINE);
   SetIndexStyle(1,DRAW_LINE);
   SetIndexStyle(2,DRAW_LINE);
//---- 3       
   SetIndexBuffer(0,UpBuffer);
   SetIndexBuffer(1,MdBuffer);
   SetIndexBuffer(2,DnBuffer);
//----        
   string short_name="Price Channel("+ChannelPeriod+")";
   IndicatorShortName(short_name);
   SetIndexLabel(0,"Up Channel");
   SetIndexLabel(1,"Middle Channel");
   SetIndexLabel(2,"Down Channel");
//----   ,       
   SetIndexDrawBegin(0,ChannelPeriod+Shift);
   SetIndexDrawBegin(1,ChannelPeriod+Shift);
   SetIndexDrawBegin(2,ChannelPeriod+Shift);
//----     
   SetIndexShift (0, Shift); 
   SetIndexShift (1, Shift);
   SetIndexShift (2, Shift);
//----  
   return(0);
  }
//+------------------------------------------------------------------+
//| Price Channel                                                    |
//+------------------------------------------------------------------+
int start()
  {
//----       
   if(Bars<=ChannelPeriod)return(0);
//----      
double high,low,price;
//----+        
int bar,kk,counted_bars=IndicatorCounted(); 
//----    
if (counted_bars<0)return(-1);
//----       
if (counted_bars>0) counted_bars--;
//----  
if(counted_bars<1)for(bar=1;bar<=ChannelPeriod;bar++) 
     {
      UpBuffer[Bars-bar]=0.0;
      DnBuffer[Bars-bar]=0.0;
      MdBuffer[Bars-bar]=0.0;
     }
//----     ,        
bar=Bars-ChannelPeriod-1;
if(counted_bars>=ChannelPeriod) bar=Bars-counted_bars-1;
//----      
while(bar>=0)
     {
       high=High[bar]; 
       low=Low[bar]; 
       kk=bar-1+ChannelPeriod;
       //----
       while(kk>=bar)
        {
         price=High[kk];
         if(high<price) high=price;
         price=Low[kk];
         if(low>price)  low=price;
         kk--;
        } 
       UpBuffer[bar]=high;
       DnBuffer[bar]=low;
       MdBuffer[bar]=(high+low)/2;
       bar--;
     }
return(0);
  }
//+-----------------------------------------------------------------------------+